from codeableModels import *
from metamodels.microserviceComponentsMetamodel import *

cartService = CClass(component, 'Cart Service', stereotypeInstances = service)
catalogueService = CClass(component, 'Catalogue Service', stereotypeInstances = service)
dispatchService = CClass(component, 'Dispatch Service', stereotypeInstances = service)
paymentService = CClass(component, 'Payment Service', stereotypeInstances = service)
ratingsService = CClass(component, 'Ratings Service', stereotypeInstances = service)
shippingService = CClass(component, 'Shipping Service', stereotypeInstances = service)
userService = CClass(component, 'User Service', stereotypeInstances = service)
NGINXAPIGateway = CClass(component, 'NGINX API Gateway', stereotypeInstances = [service, facade])
addLinks({NGINXAPIGateway: [catalogueService]}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: [userService]}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: [cartService]}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: [shippingService]}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: [paymentService]}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: [ratingsService]}, roleName = "target", stereotypeInstances = [restfulHTTP])
RESTAPIClient = CClass(component, 'REST API Client', stereotypeInstances = client)
addLinks({RESTAPIClient: [NGINXAPIGateway]}, roleName = "target", stereotypeInstances = [restfulHTTP])
webClient = CClass(component, 'Web Client', stereotypeInstances = webUI)
addLinks({webClient: [NGINXAPIGateway]}, roleName = "target", stereotypeInstances = [http])
addLinks({cartService: [catalogueService]}, roleName = "target", stereotypeInstances = [restfulHTTP, callback])
cartandAnonymousUserCountDB = CClass(component, 'Cart and Anonymous User Count DB', stereotypeInstances = redisDB)
addLinks({cartService: [cartandAnonymousUserCountDB]}, roleName = "target", stereotypeInstances = [resp, synchronousConnector, callback], taggedValues = {'description': 'async callback for saving cart, sync get, del, etc. for all other db operations'})
cartPrometheusMonitor = CClass(component, 'Cart Prometheus Monitor', stereotypeInstances = monitoringComponent)
addLinks({cartService: [cartPrometheusMonitor]}, roleName = "target", stereotypeInstances = [inMemoryConnector])
catalogueUsersOrdersDB = CClass(component, 'Catalogue Users Orders DB', stereotypeInstances = mongoDB)
addLinks({catalogueService: [catalogueUsersOrdersDB]}, roleName = "target", stereotypeInstances = [mongoWire, callback])
paypalPaymentGateway = CClass(component, 'Paypal Payment Gateway', stereotypeInstances = [service, externalComponent])
addLinks({paymentService: [paypalPaymentGateway]}, roleName = "target", stereotypeInstances = [restfulHTTP, synchronousConnector])
addLinks({paymentService: [userService]}, roleName = "target", stereotypeInstances = [restfulHTTP, synchronousConnector], label = "check for users and post orders")
addLinks({paymentService: [cartService]}, roleName = "target", stereotypeInstances = [restfulHTTP, synchronousConnector])
paymentPrometheusMonitor = CClass(component, 'Payment Prometheus Monitor', stereotypeInstances = monitoringComponent)
addLinks({paymentService: [paymentPrometheusMonitor]}, roleName = "target", stereotypeInstances = [inMemoryConnector])
instanaAgent = CClass(component, 'Instana Agent', stereotypeInstances = tracingComponent)
addLinks({cartService: [instanaAgent]}, roleName = "target", stereotypeInstances = [http2])
addLinks({catalogueService: [instanaAgent]}, roleName = "target", stereotypeInstances = [http2])
addLinks({dispatchService: [instanaAgent]}, roleName = "target", stereotypeInstances = [http2])
addLinks({paymentService: [instanaAgent]}, roleName = "target", stereotypeInstances = [http2])
addLinks({userService: [instanaAgent]}, roleName = "target", stereotypeInstances = [http2])
rabbitMQ = CClass(component, 'Rabbit MQ', stereotypeInstances = [messageBroker, pubSubComponent])
addLinks({paymentService: [rabbitMQ]}, roleName = "target", stereotypeInstances = [publisher], taggedValues = {'channel': 'orders'})
addLinks({dispatchService: [rabbitMQ]}, roleName = "target", stereotypeInstances = [subscriber], taggedValues = {'channel': 'orders'})
ratingsandShippingCitiesDB = CClass(component, 'Ratings and Shipping Cities DB', stereotypeInstances = mySQLDB)
addLinks({ratingsService: [ratingsandShippingCitiesDB]}, roleName = "target", stereotypeInstances = [mySQLProtocol])
addLinks({ratingsService: [catalogueService]}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({userService: [catalogueUsersOrdersDB]}, roleName = "target", stereotypeInstances = [mongoWire, callback], label = "users and orders")
addLinks({userService: [cartandAnonymousUserCountDB]}, roleName = "target", stereotypeInstances = [resp, callback], label = "only used to track anonymous users")
addLinks({shippingService: [cartService]}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({shippingService: [ratingsandShippingCitiesDB]}, roleName = "target", stereotypeInstances = [jdbc], label = "read only, query predefined cities table")


model = CBundle("model", elements = [cartService, catalogueService, dispatchService, paymentService, ratingsService, shippingService, userService, NGINXAPIGateway, RESTAPIClient, webClient, cartandAnonymousUserCountDB, cartPrometheusMonitor, catalogueUsersOrdersDB, paypalPaymentGateway, paymentPrometheusMonitor, instanaAgent, rabbitMQ, ratingsandShippingCitiesDB])
modelViews = [model, {}]
